using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace PDFCreatorApp
{
	/// <summary>
	/// Summary description for DocSettingsForm.
	/// </summary>
	public class DocSettingsForm : System.Windows.Forms.Form
	{
		private Amyuni.PDFCreator.acDocSettingsCtrl docSettingsCtrl;
		private System.Windows.Forms.Button buttonOk;
		private System.Windows.Forms.Button buttonCancel;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public DocSettingsForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.docSettingsCtrl = new Amyuni.PDFCreator.acDocSettingsCtrl();
			this.buttonOk = new System.Windows.Forms.Button();
			this.buttonCancel = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// docSettingsCtrl
			// 
			this.docSettingsCtrl.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.docSettingsCtrl.Location = new System.Drawing.Point(0, 0);
			this.docSettingsCtrl.Name = "docSettingsCtrl";
			this.docSettingsCtrl.Size = new System.Drawing.Size(400, 306);
			this.docSettingsCtrl.TabIndex = 0;
			// 
			// buttonOk
			// 
			this.buttonOk.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonOk.Location = new System.Drawing.Point(184, 309);
			this.buttonOk.Name = "buttonOk";
			this.buttonOk.Size = new System.Drawing.Size(105, 26);
			this.buttonOk.TabIndex = 1;
			this.buttonOk.Text = "&OK";
			this.buttonOk.Click += new System.EventHandler(this.buttonOk_Click);
			// 
			// buttonCancel
			// 
			this.buttonCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.buttonCancel.Location = new System.Drawing.Point(295, 309);
			this.buttonCancel.Name = "buttonCancel";
			this.buttonCancel.Size = new System.Drawing.Size(105, 26);
			this.buttonCancel.TabIndex = 2;
			this.buttonCancel.Text = "&Cancel";
			this.buttonCancel.Click += new System.EventHandler(this.buttonCancel_Click);
			// 
			// DocSettingsForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(400, 335);
			this.Controls.Add(this.buttonCancel);
			this.Controls.Add(this.buttonOk);
			this.Controls.Add(this.docSettingsCtrl);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.SizableToolWindow;
			this.Name = "DocSettingsForm";
			this.ShowInTaskbar = false;
			this.Text = "Document Settings";
			this.Load += new System.EventHandler(this.DocSettingsForm_Load);
			this.ResumeLayout(false);

		}
		#endregion

		private Amyuni.PDFCreator.PDFCreator m_pdf = null;

		/// <summary>
		/// 
		/// </summary>
		public Amyuni.PDFCreator.PDFCreator PDF
		{
			set
			{
				m_pdf = value;
				docSettingsCtrl.PDF = m_pdf;
			}
		}

		private static int m_lastSelectedTabIndex = 0;
		
		private void DocSettingsForm_Load(object sender, System.EventArgs e)
		{
			if ( m_pdf == null )
				throw new Amyuni.PDFCreator.IacException( "You must set the PDF property before opening this dialog." );

			docSettingsCtrl.SelectedTabIndex = m_lastSelectedTabIndex;
		}

		private void buttonOk_Click(object sender, System.EventArgs e)
		{
			if ( docSettingsCtrl.ApplyChanges() )
			{
				m_lastSelectedTabIndex = docSettingsCtrl.SelectedTabIndex;
				this.DialogResult = DialogResult.OK;
				this.Close();
			}
		}

		private void buttonCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}
	}
}
